package demo.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

import demo.common.BorderEx;
import demo.common.FunctionList;
import demo.common.Res;
import demo.module.LoginModule;
import netsdk.lib.*;
import netsdk.struct.DD_TIME;
class PlayBackFrame extends JFrame{	
	private static final long serialVersionUID = 1L;
	public static boolean init = false;//是否实例化
	private JPanel playPanel;
	private Panel playWindowOne;
	private JSlider playSlider;
	private JPanel controlPanel;
	private JButton playBtn;
	private JButton stopBtn;
	private JButton slowBtn;
	private JButton fastBtn;
	private JButton endBtn;
	private JSlider volumeSlider;
	
	private NativeLong m_playbackHandle;
	private NativeLong			m_userID;
	private int			m_channel;
	private DD_TIME			m_startTime;
	private DD_TIME			m_endTime;
	private boolean			m_isPlay;
	private boolean			m_isOpenAudio;
	private boolean			m_isPause;
	private long			m_timeElapsed;
	private int			m_currentSpeed;
	private int				m_playbackPos;
	private int				m_volume;
	private boolean			m_isDraging;
	private boolean			m_isSavingData;
	private NativeLong			m_RecFilehandle;
	private boolean			m_bMultiChannelsPlaybackMode; //是否是多路回放模式
	public PlayBackFrame(NativeLong userid, DD_TIME start, DD_TIME end, int channel, final DownLoadRecordFrame drf) {
		m_userID = userid;
		m_startTime = start;
		m_endTime = end;
		m_channel = channel;
		// TODO Auto-generated constructor stub
		//BorderEx.set(this, Res.string().getRealplay(), 2);
		setLayout(new BorderLayout());
		pack();
	    setSize(800, 660);
	    setResizable(false);
	    setLocationRelativeTo(null);
	    
		playPanel = new JPanel();		
		add(playPanel, BorderLayout.NORTH);
		
		/************ 回放窗口 **************/
		playPanel.setLayout(new BorderLayout());
		playPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		playWindowOne = new Panel();
		playWindowOne.setBackground(Color.GRAY);
		playWindowOne.setPreferredSize(new Dimension(500,400));
		playPanel.add(playWindowOne, BorderLayout.CENTER);
		/*********滑块*********************/
		playSlider = new JSlider();
		playSlider.setValue(0);
		add(playSlider, BorderLayout.CENTER);
		/*********控制面板*******************/
		controlPanel = new JPanel();
		controlPanel.setLayout(new FlowLayout());
		
		playBtn = new JButton(">");
		playBtn.setPreferredSize(new Dimension(45,25));
		controlPanel.add(playBtn);
		
		stopBtn = new JButton("口");
		stopBtn.setPreferredSize(new Dimension(45,25));
		controlPanel.add(stopBtn);
		
		slowBtn = new JButton("<<");
		slowBtn.setPreferredSize(new Dimension(48,25));
		controlPanel.add(slowBtn);
		
		fastBtn = new JButton(">>");
		fastBtn.setPreferredSize(new Dimension(48,25));
		controlPanel.add(fastBtn);
		
		endBtn = new JButton("|>");
		endBtn.setPreferredSize(new Dimension(45,25));
		controlPanel.add(endBtn);
		
		JLabel volume = new JLabel("音量");
		controlPanel.add(volume);
		
		volumeSlider = new JSlider();
		controlPanel.add(volumeSlider);
		
				
		add(controlPanel, BorderLayout.SOUTH);
		
		m_isPlay = false;
		m_playbackHandle = new NativeLong(-1);
		m_timeElapsed = 0;
		m_currentSpeed = ErrorCodeAndConst.NET_SDK_RPB_SPEED_1X;
		m_playbackPos = 0;
		m_volume = 0;
		m_isOpenAudio = false;
		m_isPause = false;
		m_isDraging = false;
		m_isSavingData = false;
		m_bMultiChannelsPlaybackMode = false;
		
		init = true;
		playBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				playBack();
			}
		});
		
		addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {	    		
	    		dispose();			    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				drf.setVisible(true);
	    			}
	    		});
	    	}
	    });
		
	}
	public void playBack() {
		if (m_isPlay && !m_isPause){//正在回放
			if (m_bMultiChannelsPlaybackMode){
				LoginModule.netsdk.NET_SDK_PlayBackControlSync( ErrorCodeAndConst.NET_SDK_PLAYCTRL_PAUSE, 0, null);
			}
			else{
				boolean ret = LoginModule.netsdk.NET_SDK_PlayBackControl(m_playbackHandle, ErrorCodeAndConst.NET_SDK_PLAYCTRL_PAUSE, 0, null);
			}			
			m_isPause = true;
		}
		else {//未回放
			if (m_playbackHandle.longValue() < 0) {
				NativeLong handle = new NativeLong(0);
				if (m_bMultiChannelsPlaybackMode) {
					
				}
				else {
					int[] channels = new int[1];					
		            channels[0] = m_channel;
		            
					Pointer[] ptrs = new Pointer[1];
					ptrs[0] = Native.getComponentPointer(playWindowOne);
					handle = LoginModule.netsdk.NET_SDK_PlayBackByTime(m_userID, channels, 1, m_startTime, m_endTime, ptrs);
				}
				if (handle.longValue() > 0) {//回放成功
					m_playbackHandle = handle;
					m_isPlay = true;
					m_isPause = false;
					m_timeElapsed = 0;
				}
				else {
					
				}
			}
			else {//暂停状态
				if (m_bMultiChannelsPlaybackMode){
					LoginModule.netsdk.NET_SDK_PlayBackControlSync( ErrorCodeAndConst.NET_SDK_PLAYCTRL_RESUME, 0, null);
				}
				else{
					LoginModule.netsdk.NET_SDK_PlayBackControl(m_playbackHandle, ErrorCodeAndConst.NET_SDK_PLAYCTRL_RESUME, 0, null);
				}				
				m_isPlay = true;
				m_isPause = false;
			}
			m_currentSpeed = ErrorCodeAndConst.NET_SDK_RPB_SPEED_1X;
		}
	}
	public void setPlayBackInfo(NativeLong userid, DD_TIME start, DD_TIME end, int channel) {
		m_userID = userid;
		m_startTime = start;
		m_endTime = end;
		m_channel = channel;
	}

}
//public class CPlayBack {
//	public static void main(String[] args) {	
//		SwingUtilities.invokeLater(new Runnable() {
//			public void run() {
//				PlayBackFrame demo = new PlayBackFrame();				
//				demo.setVisible(true);
//			}
//		});		
//	}
//}
